// RebeamformerTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <fstream>
#include <iostream>
#include <vector>
#include <cstdlib>
#include <math.h>  

//PA Rebeamformer for simulated US Beamformed data.
//Input parameters include:
//ns,nl - number of samples and number of lines (depth and width of image)
//channelSpacing - spacing between transducer elements
//freq - frequency of sampling
//rf - input rf beamformed data.
//Outputs beamformed data in array (same dimensions as input array).
double* pa_rebeamforming(const int ns, const int nl, double channelSpacing, double speedSound, double freq, double* rf) {
	double sampleSpacing = 1 / freq * speedSound * 1000;

	double* postBF = new double[ns*nl];
	double* count = new double[ns*nl];
	for (int i = 0; i < ns*nl; i++) {
		postBF[i] = 0;
		count[i] = 1;
	}

	for (int r = 1; r <= nl; r++) {
		for (int j = 1; j <= ns; j++) {
			double st_focus = (double)j / 2.0;
			int half_apt = (((((double)j - st_focus)*(sampleSpacing * 1.0) / channelSpacing)) + 0.5);
			for (int i = r - half_apt; i <= r + half_apt; i++) {
				if (i > 0 && i <= nl) {
					double depth = ((double)j - st_focus)*(sampleSpacing);
					double width = ((double)r - i) * channelSpacing;
					double rad = sqrt((depth*depth) + width*width);
					double delay = st_focus + (rad) / (sampleSpacing);
					if (round(delay) < (double)ns) {
						int delay_pos = (delay + 0.5);
						if (delay_pos > 0) {
							postBF[j - 1 + (i - 1)*(ns)] = postBF[j - 1 + (i - 1)*(ns)] + rf[delay_pos-1 + (r - 1)*ns];
							count[j - 1 + (i - 1)*(ns)]++;
						}
					}
				}
			}

		}
	}
	for (int i = 0; i < nl*ns; i++)
		postBF[i] = postBF[i] / count[i];

	delete count;
	return postBF;
}

int main()
{
	//Define beamforming parameters here.
	double soundSpeed = 1500.0;  //1540
	double channelSpacing = 60.0 / 128.0; //0.1191 
	double freq = 40e6;
	int sample = 1500; //4848
	int lines = 128;//319
	std::ifstream ifile("US_Testdata1.txt", std::ios::in);

	double* scores = new double[sample*lines];

	//Take in beamformed data from file.
	if (!ifile.is_open()) {
		std::cout << "There was a problem opening the input file!\n";
		exit(1);//exit or do additional error checking
	}

	int count = 0;
	double num = 0.0;
	while (ifile >> num) {
		scores[count] = num;
		count++;
	}
	ifile.close();

	std::cout << "Data Loaded Into System. Beginning Beamforming.\n";


	double* data = pa_rebeamforming(sample, lines, channelSpacing, soundSpeed, freq, scores);
	std::cout << "Beamforming Complete.\n";
	std::ofstream ofile("PA_Outputdata1.txt");
	//verify that the scores were stored correctly:
	for (int l = 0; l < lines; l++) {
		for (int s = 0; s < sample; s++) {
			ofile << data[s + l*sample] << ' ';
		}
		if(l != lines -1)
			ofile << '\n';
	}
	ofile.close();


	delete scores;
	std::cout << "ALL DONE :D \n";
	return 0;
}

